/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.commons.serialize;

public class StringEscapeUtil {
    private static final String[] REPLACEMENT_CHARS = new String[128];

    public static String getReplacement(char c) {
        String replacement;
        if (c < '\u0080') {
            replacement = REPLACEMENT_CHARS[c];
            if (replacement == null) {
                return null;
            }
        } else if (c == '\u2028') {
            replacement = "\\u2028";
        } else if (c == '\u2029') {
            replacement = "\\u2029";
        } else {
            return null;
        }
        return replacement;
    }

    static {
        for (int i = 0; i <= 31; ++i) {
            StringEscapeUtil.REPLACEMENT_CHARS[i] = String.format("\\u%04x", i);
        }
        StringEscapeUtil.REPLACEMENT_CHARS[34] = "\\\"";
        StringEscapeUtil.REPLACEMENT_CHARS[92] = "\\\\";
        StringEscapeUtil.REPLACEMENT_CHARS[9] = "\\t";
        StringEscapeUtil.REPLACEMENT_CHARS[8] = "\\b";
        StringEscapeUtil.REPLACEMENT_CHARS[10] = "\\n";
        StringEscapeUtil.REPLACEMENT_CHARS[13] = "\\r";
        StringEscapeUtil.REPLACEMENT_CHARS[12] = "\\f";
        StringEscapeUtil.REPLACEMENT_CHARS[0] = "\\0";
    }
}

